TITLE 								         { exa022.pde }
   'x^2+ 2*y^2'
SELECT
   spectral_colors				{ Values from red to violet }
DEFINITIONS
   Lx=1     Ly=1     f=x^2+ 2*y^2
   grad_f=vector( dx(f), dy(f))     laplace_f=dxx(f)+ dyy(f)
BOUNDARIES
region 'domain'                     			{ Closed by return to start }
   start (-Lx,-Ly) line to (Lx,-Ly) to (Lx,Ly)  to (-Lx,Ly) close
PLOTS
   grid( x, y)     					{ Triangular mesh }
   surface( f)					{ Surface in 3 dimensions }
   elevation( f) from (-Lx,-Ly) to (Lx,Ly)   { Height of f(x,y) above line }
   contour( f)                     			{ Contour plot of function }
   contour( f) painted				{ Color coded in plane }
   vector( grad_f) as 'Gradient'		{ Arrow plot with a title }
   contour( laplace_f)               		{ Test if f(x) is harmonic }
END

